@extends('layouts.app')

@section('content')
<div id="dig_modal" class="ui modal">
    <i class="close icon"></i>
    <div class="header">
        A records for <span id="dig_zone"></span>
    </div>
    <div class="content">
        <div class="description">
            <pre>
            <div id="dig_result" style="background-color:black;color:white;padding:20px;border-radius:5px;"></div>
            </pre>
        </div>
    </div>
</div>
<div class="ui stackable container">
    <div class="ui top attached header">
        <i class="clock icon"></i> {{ __('Logs') }}
    </div>
    <div class="ui teal attached segment">
        <div id="msg"></div>
        @if ($logs==null)
            {{ __('No logs found') }}
        @else
            <table id="table_logs" class="ui very compact table">
                <thead>
                    <tr>
                        <th>{{ __('Zone') }}</th>
                        <th>{{ __('Action') }}</th>
                        <th>{{ __('Server') }}</th>
                        <th>{{ __('Time') }}</th>
                    </tr>
                </thead>
                <tbody>
                @foreach($logs as $log)
                    <tr>
                        <td>{{ $log->zone }} <button data-zone="{{ $log->zone }}" class="ui right floated right labeled icon mini button dig_btn"><i class="terminal icon"></i>dig check</button></td>
                        <td>{{ $log->action }}</td>
                        <td>{{ $log->server_name }}</td>
                        <td data-order="{{ $log->timestamp }}">{{ \Carbon\Carbon::parse($log->timestamp)->format('j F Y H:i') }}</td>
                    </tr>
                @endforeach
                </tbody>
            </table>
        @endif
    </div>
</div>
<link rel="stylesheet" type="text/css" href="https://cdn.datatables.net/1.10.18/css/dataTables.semanticui.min.css">
<script type="text/javascript" src="https://cdn.datatables.net/1.10.18/js/jquery.dataTables.min.js"></script>
<script type="text/javascript" src="https://cdn.datatables.net/1.10.18/js/dataTables.semanticui.min.js"></script>

<script>
$(document).ready(function() {
    $.ajaxSetup({
        headers: {
            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
        }
    });
    $('#table_logs').DataTable(
        {
            "pageLength": 50,
            "order": [[3, "desc"]]
        }
    );

    $('#table_logs').on('click', '.dig_btn', function() {
        var zone = $(this).data('zone');
        $('#dig_zone').html(zone);
        $('#dig_modal')
            .modal('show');
        $.ajax({
            type : 'POST',
            url : '/digcheck',
            data : {zone:zone},
            beforeSend : function ()
            {
                $('#dig_result').html('<div class="ui active centered inline loader"></div>');
            },
            success : function(response) 
            {
                var output = '<table>';
                for (var i = 0; i < response.message.length; i++)
                {
                    output = output + '<tr><td>' + Object.keys(response.message[i])[0] + ':</td><td>';
                    //output = output +  Object.keys(response.message[i])[0] + " : ";
                    for (var key in response.message[i])
                    {
                        output = output + ' ' + response.message[i][key];
                        //output = output + response.message[i][key];
                    }
                    output = output + '</td></tr>';
                }
                output = output + '</table>';
                if (response.code == "ok")
                {
                    $('#dig_result').html(output);
                }
                else
                {
                    $('#dig_result').html('Command failed.');
                }
            }
        });
    });
} );
</script>
@endsection
