@extends('layouts.app')

@section('content')
<div class="ui stackable container">
    @if (!$cluster)
        {{ __('Cluster not found') }}
    @else
        <div class="ui top attached header">
            <i class="sitemap icon"></i> {{ $cluster->name }}
        </div>
        <div class="ui teal attached segment">
            <form class="ui stackable form" method="POST" action="">
                <div class="field">
                    <div class="ui input">
                        <input type="text" name="name" value="{{ $cluster->name }}" placeholder="Cluster name" required autofocus>
                    </div>
                </div>
                <div class="field">
                <div class="ui checkbox">
                        <input type="checkbox" @if ($cluster->email_notifications) {{ __('checked') }} @endif name="notification">
                        <label>E-mail notifications</label>
                    </div>
                </div>
                <div class="ui action">
                    @csrf
                    <input type="submit" class="ui primary button" value="Save">
                </div>
            </form>
        </div>
    @endif
</div>
@endsection
 
