@extends('layouts.app')

@section('content')
<!-- Exclude Modal content -->
<div class="ui basic modal exclude">
    <div class="ui icon header">
        <i class="exclamation mark icon"></i>
        Excluding <span class="modal_zone"></span>
    </div>
    <div class="content">
        Exclude <span class="modal_zone"></span> at <span class="modal_server"></span>?
    </div>
    <div class="actions">
        <div class="ui red basic cancel inverted button">
            <i class="close icon"></i>
            No
        </div>
        <div class="ui green ok inverted button">
            <i class="exclamation mark icon"></i>
            Yes
        </div>
    </div>

</div>
<!-- /Modal content -->
<!-- Remove Exclude Modal content -->
<div class="ui basic modal remove_exclude">
    <div class="ui icon header">
        <i class="trash mark icon"></i>
        Removing exclusion of <span class="modal_remove_zone"></span>
    </div>
    <div class="content">
        Remove exclusion of <span class="modal_remove_zone"></span> at <span class="modal_remove_server"></span>?
    </div>
    <div class="actions">
        <div class="ui red basic cancel inverted button">
            <i class="close icon"></i>
            No
        </div>
        <div class="ui green ok inverted button">
            <i class="exclamation mark icon"></i>
            Yes
        </div>
    </div>

</div>
<!-- /Modal content -->
<div class="ui stackable fluid container">
    <div class="ui stackable grid">
        <div class="eight wide column">   
            <div class="ui top attached header">
                <i class="globe icon"></i> Zones
            </div>
            <div class="ui teal attached center aligned segment">
                @if (count($zones) === 0)
                    {{ __('No zones found.') }}
                @else
                    <div id="msg">

                    </div>
                    <table id="table_zones" class="ui very compact table">
                        <thead>
                            <tr>
                                <th>Name</th>
                                <th>Server</th>
                                <th>Insert date</th>
                                <th></th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach ($zones as $zone)
                                <tr>
                                    <td>{{ $zone->zone }}</td>
                                    <td>{{ $zone->getServer() }}</td>
                                    <td data-order="{{ $zone->insert_date }}">{{ \Carbon\Carbon::parse($zone->insert_date)->format('j M Y H:i') }}</td>
                                    <td><button class="ui orange mini right labeled icon button btn_exclude" data-server_name="{{ $zone->getServer() }}" data-zone="{{ $zone->zone }}" data-server="{{ $zone->server_id }}"><i class="exclamation mark icon"></i> EXCLUDE</button></td>
                                </tr>
                            @endforeach
                        </tbody>
                    </table>
                @endif
            </div>
        </div>
        <div class="eight wide column">
            <div class="ui top attached header">
                <i class="exclamation mark icon"></i> Excluded zones
            </div>
            <div class="ui teal attached center aligned segment">
                @if (count($excluded_zones) === 0)
                    {{ __('No zones found.') }}
                @else
                    <div id="msg_remove">

                    </div>
                    <table id="table_excludes" class="ui very compact table">
                        <thead>
                            <tr>
                                <th>Name</th>
                                <th>Server</th>
                                <th></th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach ($excluded_zones as $zone)
                                <tr>
                                    <td>{{ $zone->zone }}</td>
                                    <td>{{ $zone->getServer() }}</td>
                                    <td><button class="ui red mini right labeled icon button btn_remove_exclude" data-server_name="{{ $zone->getServer() }}" data-zone="{{ $zone->zone }}" data-server="{{ $zone->server_id }}"><i class="trash icon"></i> REMOVE EXCLUSION</button></td>
                                </tr>
                            @endforeach
                        </tbody>
                    </table>
                @endif
            </div> <!-- excluded segment -->
            <div class="ui attached header">
                <i class="clone icon"></i> Duplicate zones
            </div>
            <div class="ui orange bottom attached center aligned segment">
                @if (count($duplicates) === 0)
                    {{ __('No duplicate zones found.') }}
                @else
                    <div id="msg_dup">

                    </div>
                    <table id="table_duplicates" class="ui very compact table">
                        <thead>
                            <tr>
                                <th>Name</th>
                                <th>Servers</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach ($duplicates as $zone)
                                <tr>
                                    <td>{{ $zone->zone }}</td>
                                    <td>
                                    @foreach( $zone->getDuplicateServers() as $dup)
                                        <span class="ui tiny label">{{ $dup->name }}</span> <button class="ui orange mini right labeled icon button btn_exclude" data-server_name="{{ $dup->name }}" data-zone="{{ $zone->zone }}" data-server="{{ $dup->id }}"><i class="exclamation mark icon"></i> EXCLUDE from {{ $dup->name }}</button>
                                    @endforeach
                                    </td>
                                </tr>
                            @endforeach
                        </tbody>
                    </table>
                @endif
            </div>
        </div> <!-- column -->
    </div>    <!-- grid -->
</div>
<link rel="stylesheet" type="text/css" href="https://cdn.datatables.net/1.10.18/css/dataTables.semanticui.min.css">
<script type="text/javascript" src="https://cdn.datatables.net/1.10.18/js/jquery.dataTables.min.js"></script>
<script type="text/javascript" src="https://cdn.datatables.net/1.10.18/js/dataTables.semanticui.min.js"></script>


<script type="text/javascript">
    $(document).ready(function () {
        $('#table_zones').DataTable({
            "pageLength": 100
        });
        $('#table_excludes').DataTable();

        $.ajaxSetup({
            headers: {
                'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
            }
        });
        $(document).on('click', '.btn_exclude',  function () {
            var zone = $(this).data('zone');
            var server = $(this).data('server');
            var server_name = $(this).data('server_name')
            $('.modal_zone').text(zone);
            $('.modal_server').text(server_name);
            $('.ui.basic.modal.exclude')
                .modal({
                    onApprove : function() {
                        $.ajax({
                            type : 'POST',
                            url : '/zones/exclude',
                            data : {zone:zone, server:server},
                            success : function(response) 
                                {
                                    if (response.code == "ok")
                                    {
                                        $('#msg').html('<div class="ui positive message"><i class="close icon"></i>\
                                        ' + response.message + '\
                                        </div>');
                                    }
                                    else
                                    {
                                        $('#msg').html('<div class="ui negative message"><i class="close icon"></i>\
                                        ' + response.message + '\
                                        </div>');
                                    }
                                    $('.message .close')
                                    .on('click', function() {
                                        $(this)
                                            .closest('.message')
                                            .transition('fade');
                                    });
                                }
                        })

                        return true;
                    }
                })
                .modal('show');
        });
        $(document).on('click', '.btn_remove_exclude', function ()
        {
            var zone = $(this).data('zone');
            var server = $(this).data('server');
            var server_name = $(this).data('server_name')
            $('.modal_remove_zone').text(zone);
            $('.modal_remove_server').text(server_name);
            $('.ui.basic.modal.remove_exclude')
                .modal({
                    onApprove : function() {
                        $.ajax({
                            type : 'POST',
                            url : '/zones/exclude/remove',
                            data : {zone:zone, server:server},
                            success : function(response) 
                                {
                                    if (response.code == "ok")
                                    {
                                        $('#msg_remove').html('<div class="ui positive message"><i class="close icon"></i>\
                                        ' + response.message + '\
                                        </div>');
                                    }
                                    else
                                    {
                                        $('#msg_remove').html('<div class="ui negative message"><i class="close icon"></i>\
                                        ' + response.message + '\
                                        </div>');
                                    }
                                    $('.message .close')
                                    .on('click', function() {
                                        $(this)
                                            .closest('.message')
                                            .transition('fade');
                                    });
                                }
                        })

                        return true;
                    }
                })
                .modal('show');
        });
    });
</script>
@endsection
