@extends('layouts.app')

@section('content')
<div class="ui stackable container">
        <div class="ui top attached header">
            <i class="chart area icon"></i> Graphs
        </div>
        <div class="ui teal attached segment">
            <canvas id="insert_delete_chart" width="400" height="400"></canvas>
        </div>
		<div class="ui teal attached segment">
            <canvas id="zones_chart" width="400" height="400"></canvas>
        </div>

</div>
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/Chart.js/2.8.0/Chart.min.css" integrity="sha256-aa0xaJgmK/X74WM224KMQeNQC2xYKwlAt08oZqjeF0E=" crossorigin="anonymous" />
<script src="https://cdnjs.cloudflare.com/ajax/libs/Chart.js/2.8.0/Chart.min.js" integrity="sha256-Uv9BNBucvCPipKQ2NS9wYpJmi8DTOEfTA/nH2aoJALw=" crossorigin="anonymous"></script>

<script>
    var ctx = document.getElementById('insert_delete_chart').getContext('2d');
var myChart = new Chart(ctx, {
    type: 'line',
    data: {
		labels: [
			@foreach ($logs as $log)
			'{{ $log->year }} {{ $log->monthname }}',
			@endforeach
		],
        datasets: [{
            label: '# of Inserts',
			data: [
				@foreach ($logs as $log)
				{{ $log->count_insert }},
				@endforeach
			],
            borderColor: 'rgb(0, 159, 64, 1)',
			fill: false,
			lineTension: 0
        },{
            label: '# of Deletes',
			data: [
				@foreach ($logs as $log)
				{{ $log->count_delete }},
				@endforeach
			],
            borderColor: 'rgb(159, 0, 64)',
			fill: false,
			lineTension: 0
        }]
    },
	options: {
		tooltips: {
			mode: 'index',
			intersect: false
		},
        title: {
            display: true,
            text: 'Monthly deletes/inserts',
        },
		responsive: true,
		maintainAspectRatio: false,
	}
});
var zonesChart = document.getElementById('zones_chart').getContext('2d');
var myChart = new Chart(zonesChart, {
    type: 'horizontalBar',
    data: {
		labels: [
			@foreach ($servers as $server)
			'{{ $server->name }}',
			@endforeach
		],
        datasets: [{
            label: 'Zones count',
			data: [
				@foreach ($servers as $server)
				{{ $server->zones_count }},
				@endforeach
			],
			backgroundColor: 'rgba(0, 150, 64, 0.6)',
			fill: true,
        }],
	},
	options: {
		tooltips: {
			mode: 'index',
			intersect: false
		},
        title: {
            display: true,
            text: 'Zones per server',
        },
		responsive: true,
		maintainAspectRatio: false,
	}
});
</script>
@endsection
