@extends('layouts.app')

@section('content')
<div class="ui stackable container">
    @if ($server == null)
        {{ __('Server not found') }}
    @else
    <div class="ui top attached header">
            <i class="trash icon"></i>Delete {{ $server->name }}
        </div>
        <div class="ui teal attached segment">
            <form class="ui stackable form" method="POST" action="">
                <div class="ui red message">
                    {{ __('Deleting a server will delete its zones from zCloud\'s database.')}}
                </div>
                <input type="hidden" name="server_id" value="{{ $server->id }}">
                <div class="ui action">
                    @csrf
                    <input type="submit" class="ui primary button" value="Delete">
                </div>
            </form>
        </div>
        
    @endif
</div>
@endsection
 
