@extends('layouts.app')

@section('content')
<div class="ui stackable container">
    @if (!$cluster)
        {{ __('Cluster not found') }}
    @else
        <div class="ui top attached header">
            <i class="sitemap icon"></i> {{ $cluster->name }}
        </div>
        @if ($servers_count == 0)
            <div class="ui teal center aligned attached segment">
                <form class="ui stackable form" method="POST" action="">
                    <div class="ui action">
                    @csrf
                    <input type="submit" class="ui negative button" value="Delete {{ $cluster->name }}">
                </div>

                </form>
            </div>
        @else
            <div class="ui orange attached segment">
               {{ __('You have to manually remove all servers in this cluster before deleting this cluster.')  }}
            </div>
        @endif 
    @endif
</div>
@endsection
 
